/*
 * Decompiled with CFR 0.152.
 */
package io.github.cat24a.klowenia_tales.util;

public class Hash {
    public static final int DOOR_RIGHT = 0;
    public static final int DOOR_UP = 1;
    public static final int LOCK_GOLD = 2;
    public static final int KEY_DRAWER = 3;
    public static final int COLORED_KEY = 4;
    public static final float DOOR_PROBABILITY = 0.5f;
    public static final float GOLD_LOCK_PROBABILITY = 0.3f;
    public static final float COLORED_KEY_PROBABILITY = 0.1f;

    public static long mix64(long z) {
        z = (z ^ z >>> 33) * -49064778989728563L;
        z = (z ^ z >>> 33) * -4265267296055464877L;
        return z ^ z >>> 33;
    }

    public static long hash(int x, int y, int seed, int feature) {
        long combined = Hash.mix64(x);
        combined = combined * 31L + Hash.mix64(y);
        combined = combined * 31L + Hash.mix64(seed);
        combined = combined * 31L + Hash.mix64(feature);
        long hash = Hash.mix64(combined);
        return hash;
    }

    public static boolean probabilityHash(int x, int y, int seed, int feature, double probability) {
        if (feature == 0 && y == 0 && (x == -1 || x == 0)) {
            return true;
        }
        if (feature == 1 && x == 0 && (y == -1 || y == 0)) {
            return true;
        }
        if (probability <= 0.0) {
            return false;
        }
        if (probability >= 1.0) {
            return true;
        }
        long hash = Hash.hash(x, y, seed, feature);
        double normalized = (double)(hash >>> 1) / 9.223372036854776E18;
        return normalized < probability;
    }

    public static long roomHash(int x, int y) {
        long packedRoomCoordinates = (long)x & 0xFFFFFFFFL;
        return packedRoomCoordinates |= (long)(y << 32);
    }
}

